% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbfc.R
\name{data_disc}
\alias{data_disc}
\title{Data set discretization and formatting}
\usage{
data_disc(data, n_train = NULL, missing = "?")
}
\arguments{
\item{data}{Data frame, where the last column must be the class variable.}

\item{n_train}{Number of data frame rows to use as the training set - the rest are used for the test set. If NULL, all rows are used for training, and there is no test set (default=NULL).}

\item{missing}{Label that denotes missing values in your data frame (default='?').}
}
\value{
A discretized data set:
\describe{     
\item{\code{TrainX}}{Matrix containing the training data.}
\item{\code{TrainY}}{Vector containing the class labels for the training data.}
\item{\code{TestX}}{Matrix containing the test data (optional).}
\item{\code{TestY}}{Vector containing the class labels for the test data (optional).}
}
}
\description{
Removes rows containing missing data, and discretizes the data set using Minimum Description Length Partitioning (MDLP).
}
\examples{
data(iris)
iris_disc = data_disc(iris)
}

