% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brick.R
\docType{methods}
\name{brick}
\alias{brick}
\alias{brick,Satellite-method}
\title{Convert selected layers of a Satellite object to a RasterBrick}
\usage{
\S4method{brick}{Satellite}(x, layer = names(x), ...)
}
\arguments{
\item{x}{an object of class 'Satellite'}

\item{layer}{character vector (bcde codes) or integer vector (index) of 
the layers to be stacked}

\item{...}{additional arguments passed on to \code{\link{brick}}}
}
\description{
Convert selected layers of a Satellite object to a RasterBrick
}
\examples{
path <- system.file("extdata", package = "satellite")
files <- list.files(path, pattern = glob2rx("LC08*.TIF"), full.names = TRUE)
sat <- satellite(files)

brck <- brick(sat, c("B001n", "B002n", "B003n"))
brck

}
