% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snowprofile.R
\name{validate_snowprofile}
\alias{validate_snowprofile}
\title{Validate correctness of snowprofile object}
\usage{
validate_snowprofile(object, silent = FALSE)
}
\arguments{
\item{object}{a \link{snowprofile} object to be validated}

\item{silent}{remain silent upon error (i.e., don't raise error, but only print it)}
}
\value{
Per default an error is raised when discovered, if \code{silent = TRUE} the error is only printed and the
error message returned (Note: a warning is never returned but only printed!).
If the function is applied to multiple objects, the function returns \code{NULL} for each object if no error
is encountered (see examples below).
}
\description{
Validator function that checks if snowprofile standards are being met and raises an error if mandatory fields are
missing or data types are incorrect. The function raises a warning when unknown field names are encountered.
}
\examples{

## Validate individual snowprofile and raise an error
## in case of a malformatted profile:

## (1) no error
validate_snowprofile(SPgroup[[1]])

## (2) malformatted profile --> error
this_throws_error <- TRUE
if (!this_throws_error) {
validate_snowprofile(SPmalformatted[[1]])
}

## Validate a list of snowprofiles and raise an error
## when the first error is encountered:
## (i.e., stop subsequent execution)

## (1) no error
lapply(SPgroup, validate_snowprofile)

## (2) malformatted profile --> error
if (!this_throws_error) {
lapply(SPmalformatted, validate_snowprofile)
}

## Validate a list of snowprofiles and continue execution,
## so that you get a comprehensive list of errors of all profiles:
if (!this_throws_error) {
errorlist <- lapply(SPmalformatted, validate_snowprofile, silent = TRUE)
errorlist[sapply(errorlist, function(item) !is.null(item))]  # print profiles that caused errors
}

}
\seealso{
\link{reformat_snowprofile}
}
