% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getColoursSnowTemp.R
\name{getColoursSnowTemp}
\alias{getColoursSnowTemp}
\title{Gets colours for plotting snow temperature values}
\usage{
getColoursSnowTemp(Values, Resolution = 101, Verbose = FALSE)
}
\arguments{
\item{Values}{Snow temperature values}

\item{Resolution}{Resolution of colour scale. Default is 100.}

\item{Verbose}{Switch for writing out value and html colour tuplets for debugging.}
}
\value{
Array with HTML colour codes
}
\description{
Gets colours for plotting snow temperature values in snowprofiles. Colours are consistent with niViz at https://niviz.org
}
\examples{

SnowTemp <- c(-25:0)
plot(x = rep(1,length(SnowTemp)), y = SnowTemp,
     col = getColoursSnowTemp(SnowTemp), pch = 19,cex = 3)

}
\seealso{
\link{getColoursDensity}, \link{getColoursGrainSize}, \link{getColoursGrainType}, \link{getColoursHardness}, \link{getColoursLWC}
}
\author{
phaegeli
}
