% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getColoursGrainType.R
\name{getColoursGrainType}
\alias{getColoursGrainType}
\title{Gets colours for plotting snow grain types}
\usage{
getColoursGrainType(Grains, grainDict. = grainDict)
}
\arguments{
\item{Grains}{grain type (character or list of characters)}

\item{grainDict.}{lookup table to use. Note, the easiest and best way to do this is via \code{setColoursGrainType}. This input variable here
is only a hack to change the grainDict explicitly when calling \code{plot.snowprofile} via \code{Col}, and beforehand computing
\code{Col = Col <- sapply(Profile$layers$gtype, function(x) getColoursGrainType(x, grainDict = setColoursGrainType('sarp-reduced')))};
This is only necessary in specific environments (e.g. a shiny app)}
}
\value{
Array with HTML colour codes
}
\description{
Grain colours are defined in the \code{grainDict} data.frame and the definitions can be changed with \code{setColoursGrainType}
}
\examples{

Grains <- c('PP', 'DF', 'RG', 'FC', 'FCxr', 'DH', 'SH', 'MF', 'MFcr', 'IF')
Colours <- getColoursGrainType(Grains)
Colours

plot(1:length(Grains), col = Colours, pch = 20, cex = 3)
text(1:length(Grains), 1:length(Grains), Grains, pos = 1)

}
\seealso{
\link{setColoursGrainType}, \link{getColoursDensity}, \link{getColoursGrainSize}, \link{getColoursHardness}, \link{getColoursLWC}, \link{getColoursSnowTemp}
}
\author{
phaegeli, shorton, fherla
}
