% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSPalignment.R
\name{plotSPalignment}
\alias{plotSPalignment}
\title{Align and plot two snow profiles using DTW}
\usage{
plotSPalignment(
  query,
  ref,
  dtwAlignment = NULL,
  keep.alignment = FALSE,
  plot.costDensity = FALSE,
  plot.warpedQuery = TRUE,
  label.ddate = FALSE,
  segCol = "gray70",
  segLty = "dotted",
  segLwd = 1,
  segTidy = FALSE,
  segInd = TRUE,
  segEmph = NA,
  cex = 1,
  mainQu = "query",
  mainRef = "reference",
  mainQwarped = "warped query",
  emphasizeLayers_qu = FALSE,
  emphasizeLayers_ref = FALSE,
  failureLayers_qu = FALSE,
  failureLayers_qu_col = "red",
  ...
)
}
\arguments{
\item{query}{The query snowprofile to be warped}

\item{ref}{The reference snowprofile to be warped against}

\item{dtwAlignment}{\code{dtwSP} object (optional)}

\item{keep.alignment}{Return \code{dtwSP} object with resampled query, ref and warped query? boolean}

\item{plot.costDensity}{First graph, \link{plotCostDensitySP} with warping path? boolean, default = FALSE}

\item{plot.warpedQuery}{plot warped query additionally to query, ref and alignment segments? (i.e. three pane plot) boolean, default = TRUE}

\item{label.ddate}{Label deposition date in profiles? (Only possible if \code{ddate} is given in 'dims', cf \link{distanceSPlayers})}

\item{segCol}{Color of alignment segments. Passed to \link{gpar}, default = "gray70"}

\item{segLty}{Linestyle of alignment segments. Passed to \link{gpar}, default = "dotted"}

\item{segLwd}{Linewidth of alignment segments, default = 1}

\item{segTidy}{Tidy up alignment segments, if profiles have not been resampled? boolean,
default FALSE i.e. one segment line per (synthetic) layer interface -> supports visual understanding of alignment, but is also often confusing
(segTidy currently only implemented for tidying up to gtype and hardness interfaces)}

\item{segInd}{Index vector of query layers that will get alignment segments drawn. Note, that the profiles might get resampled, so pre-calculate your correct indices!}

\item{segEmph}{Index vector of query layers, the alignment segments of which will be emphasized (thick and red). Note, that the profiles might get resampled, so pre-calculate your correct indices!}

\item{cex}{font size, cf. \code{par}}

\item{mainQu}{subtitle for query subfigure}

\item{mainRef}{subtitle for reference subfigure}

\item{mainQwarped}{subtitle for warped query subfigure}

\item{emphasizeLayers_qu}{emphasize Layers in query, see \link[sarp.snowprofile:plot.snowprofile]{sarp.snowprofile::plot.snowprofile}}

\item{emphasizeLayers_ref}{emphasize Layers in reference, see \link[sarp.snowprofile:plot.snowprofile]{sarp.snowprofile::plot.snowprofile}}

\item{failureLayers_qu}{draw arrow to failure layers (see \link[sarp.snowprofile:plot.snowprofile]{sarp.snowprofile::plot.snowprofile})? provide height vector.}

\item{failureLayers_qu_col}{color of arrow(s) (individual color string or vector, see \link[sarp.snowprofile:plot.snowprofile]{sarp.snowprofile::plot.snowprofile})}

\item{...}{Arguments passed to \code{\link{distanceSPlayers}} and \code{\link{dtwSP}}}
}
\value{
dtw object with the resampled '$query' and '$reference', as well as the warped query '$queryWarped'
(only if keep.alignment is TRUE)
}
\description{
This is a plotting routine for the DTW alignment of two snow profiles. Either provide two snow profiles or
a \code{dtwSP} alignment object. Don't resize the figure, otherwise the plotted alignment segments will not be
in correct place anymore! If you need a specific figure size, use \code{grDevices::png} with a width/height aspect
ratio of about 5/3.
}
\examples{

plotSPalignment(SPpairs$B_modeled1, SPpairs$B_modeled2)

plotSPalignment(SPpairs$B_modeled1, SPpairs$B_modeled2, dims = c("gtype"), weights = c(1))

## alternatively keep alignment:
alignment <- plotSPalignment(SPpairs$B_modeled1, SPpairs$B_modeled2, keep.alignment = TRUE)
print(paste("Similarity between profiles:", alignment$sim))

## alternatively, with precomputed alignment and emphasized layer matches:
dtwAlignment <- dtwSP(SPpairs$A_modeled, SPpairs$A_manual, open.end = FALSE)
plotSPalignment(dtwAlignment = dtwAlignment, segEmph = c(190, 192))

## directly after plotting, add text to figure:
grid::grid.text("Profiles SPpairs$A (modeled/manual)", x = 0.5, y = 0.8,
                gp = grid::gpar(fontsize=12, col="grey"))


}
\author{
fherla
}
