% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{sim2dist}
\alias{sim2dist}
\title{Convert 'similarity' matrix to 'distance' matrix}
\usage{
sim2dist(SimMat)
}
\arguments{
\item{SimMat}{similarity matrix of type data.frame with ranges [0, 1]}
}
\value{
copy of input data.frame with similarities inverted to distances (i.e. dist = 1 - sim)
}
\description{
Convert a 'similarity' matrix to 'distance' matrix. \emph{Note} that the similarity must be normalized (i.e. within [0, 1])
}
\examples{

## the 'swissSimilarityMatrix' as similarity and as distance
graphics::image(as.matrix(swissSimilarityMatrix))
graphics::image(as.matrix(sim2dist(swissSimilarityMatrix)))

}
\author{
fherla
}
