% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{extractFromScoringMatrix}
\alias{extractFromScoringMatrix}
\title{Extract from Scoring matrix}
\usage{
extractFromScoringMatrix(
  ScoringFrame,
  grainType1,
  grainType2,
  profile_handle = NULL
)
}
\arguments{
\item{ScoringFrame}{Scoring matrix of type data.frame (needs to be of symmetric, matrix like format)}

\item{grainType1}{character vector (yes, vector!) of grain type contained in ScoringFrame}

\item{grainType2}{same as \code{grainType1}}

\item{profile_handle}{character or numeric handle that links a potential warning message to the set of grain types,
if an unknown grain type is encountered (must be of length = 1)}
}
\value{
numeric vector of length \code{grainType1} with the elements of \code{ScoringFrame}
that are defined by \code{grainType1} and \code{grainType2}
}
\description{
Vectorized function to efficiently extract elements from scoring matrix of type data.frame
}
\author{
fherla
}
