% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{lbl_intervals}
\alias{lbl_intervals}
\title{Labels using set notation}
\usage{
lbl_intervals(raw = FALSE)
}
\arguments{
\item{raw}{Logical. Always use raw \code{breaks} in labels, rather than e.g. quantiles
or standard deviations.}
}
\value{
A vector of labels for \code{chop}, or a function that creates labels.
}
\description{
Labels using set notation
}
\details{
Mathematical set notation is as follows:
\itemize{
\item \code{[a, b]}: all numbers \code{x} where \verb{a <= x <= b};
\item \code{(a, b)}: all numbers where \verb{a < x < b};
\item \code{[a, b)}: all numbers where \verb{a <= x < b};
\item \code{(a, b]}: all numbers where \verb{a < x <= b};
\item \code{{a}}: just the number \code{a}.
}
}
\examples{
tab(-10:10, c(-3, 0, 0, 3), labels = lbl_intervals())
}
\seealso{
Other labelling functions: 
\code{\link{lbl_dash}()},
\code{\link{lbl_format}()},
\code{\link{lbl_manual}()},
\code{\link{lbl_seq}()}
}
\concept{labelling functions}
