% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sandwich.ci.r
\name{sandwich.ci}
\alias{sandwich.ci}
\title{Calculate confidence interval for the mean}
\usage{
sandwich.ci(object,
       level=.95)
}
\arguments{
\item{object}{A \code{sandwich.model} object generated by \code{\link{sandwich.model}}.}

\item{level}{The confidence level required. By default, \code{level} = .95.}
}
\value{
A \code{sandwich.ci} object that contains the lower and upper bounds of confidence intervals.
}
\description{
Calculate the confidence interval for the mean of each reporting unit.
}
\examples{
data(hs.data)
hs.sw <- sandwich.model(object=hs.data, sampling.attr="Population", type="shp")
hs.sw.ci <- sandwich.ci(object=hs.sw, level=.95)

}
\seealso{
\code{\link{autoplot}}, \code{\link{sandwich.model}}
}
