% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelHMMR.R
\docType{class}
\name{ModelHMMR-class}
\alias{ModelHMMR-class}
\alias{ModelHMMR}
\title{A Reference Class which represents a fitted HMMR model.}
\description{
ModelHMMR represents an estimated HMMR model.
}
\section{Fields}{

\describe{
\item{\code{param}}{An object of class \link{ParamHMMR}. It contains the
estimated values of the parameters.}

\item{\code{stat}}{An object of class \link{StatHMMR}. It contains all the
statistics associated to the HMMR model.}
}}

\section{Methods}{

\describe{
\item{\code{plot(what = c("predicted", "filtered", "smoothed", "regressors",
  "loglikelihood"), ...)}}{Plot method.
\describe{
  \item{\code{what}}{The type of graph requested:
    \itemize{
      \item \code{"predicted" = } Predicted time series and predicted
        regime probabilities (fields \code{predicted} and
        \code{predict_prob} of class \link{StatHMMR}).
      \item \code{"filtered" = } Filtered time series and filtering
        regime probabilities (fields \code{filtered} and
        \code{filter_prob} of class \link{StatHMMR}).
      \item \code{"smoothed" = } Smoothed time series, and
        segmentation (fields \code{smoothed} and \code{klas} of the
        class {StatHMMR}).
      \item \code{"regressors" = } Polynomial regression components
        (fields \code{regressors} and \code{tau_tk} of class
      \link{StatHMMR}).
      \item \code{"loglikelihood" = } Value of the log-likelihood for
        each iteration (field \code{stored_loglik} of class
        \link{StatHMMR}).
    }
  }
  \item{\code{\dots}}{Other graphics parameters.}
}
By default, all the graphs mentioned above are produced.}

\item{\code{summary(digits = getOption("digits"))}}{Summary method.
\describe{
\item{\code{digits}}{The number of significant digits to use when
printing.}
}}
}}

\examples{
data(univtoydataset)

hmmr <- emHMMR(univtoydataset$x, univtoydataset$y, K = 5, p = 1, verbose = TRUE)

# hmmr is a ModelHMMR object. It contains some methods such as 'summary' and 'plot'
hmmr$summary()
hmmr$plot()

# hmmr has also two fields, stat and param which are reference classes as well

# Log-likelihood:
hmmr$stat$loglik

# Parameters of the polynomial regressions:
hmmr$param$beta
}
\seealso{
\link{ParamHMMR}, \link{StatHMMR}
}
