% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratasamplesize.R
\name{stratasamplesize}
\alias{stratasamplesize}
\title{Sample size estimation on stratified sampling}
\usage{
stratasamplesize(
  Nh,
  var,
  error,
  alpha,
  estimator = c("total", "mean", "proportion", "class total"),
  alloc = c("prop", "min"),
  replace = FALSE
)
}
\arguments{
\item{Nh}{Vector of population strata sizes.}

\item{var}{Vector of estimated strata variances.}

\item{error}{Sampling error.}

\item{alpha}{Significance level to obtain confidence intervals.}

\item{estimator}{The estimator to be estimated. Default is "total".}

\item{alloc}{The allocation to be used when taking samples. Default is "prop".}

\item{replace}{Whether the samples to be taken can have repeated instances or not.}
}
\value{
Number of instances of the sample to be taken.
}
\description{
Calculates the required sample size in order to achieve an
absolute sampling error  less or equal to the specified for an specific
estimator and an optional confidence interval in stratified sampling.
}
\details{
With "proportion" and "class total" estimators variance vector must
contain \code{\link{var}} return values equal to p*(1-p)/(Nh-1) values.
}
\examples{
stratasamplesize(Nh=c(120,100,110,50), var=c(458, 313,407,364), error=5, alpha=0.05, "mean", "prop")

}
