% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratasample.R
\name{stratasample}
\alias{stratasample}
\title{Stratified sample}
\usage{
stratasample(data, n, replace = FALSE)
}
\arguments{
\item{data}{Population data consisting of a number of columns of data and a last
column specifying the strata each instance belongs to.}

\item{n}{Numeric array of sample sizes for each strata to be taken.}

\item{replace}{Whether the sample to be taken can have repeated instances or not.}
}
\value{
A list containing one strata sample per index.
}
\description{
With this function you receive a sample of each strata within your
data with specified size for each strata.
}
\details{
n length must be equal to number of strata in data.\cr
On return list each strata sample can be accessed calling object$strataname where
strataname are values of the last column of the original data.
}
\examples{
data<-cbind(rnorm(500, 50, 20), rep(c("clase 1", "clase 2","clase 3","clase4"),125))
stratasample(data=data, n=c(10,20,30,40))
}
