% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/salty-package.R
\docType{package}
\name{salty}
\alias{salty}
\alias{salty-package}
\title{salty: Turn Clean Data Into Messy Data}
\description{
Insert, delete, replace, and substitute bits of your data with messy values.
}
\details{
Convenient wrappers such as \link{salt_punctuation} are provided for quick access
to this package's functionality with simple defaults. For more fine-grained
control, use one of the underlying \code{salt_} functions:
\itemize{
\item \link{salt_insert} will insert new characters into some of the values of \code{x}. All
the original characters of the original values will be maintained.
\item \link{salt_substitute} will substitute some characters in some of the values of
\code{x} in place of some of the original characters.
\item \link{salt_replace} will replace some characters in some of the values of \code{x}.
Unlike \link{salt_substitute}, \link{salt_replace} does conditional replacement dependent
on the original values of \code{x}, such as changing capitalization or simulating
OCR errors based on certain character combinations.
\item \link{salt_delete} will remove some characters in the values of \code{x}
\item \link{salt_na} and \link{salt_empty} will replace some values of \code{x} with \code{NA} or with
empty strings.
\item \link{salt_swap} replaces entire values of \code{x} with new strings
}
}
