% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-metadata.R
\name{sf_describe_object_fields}
\alias{sf_describe_object_fields}
\title{Describe Object Fields}
\usage{
sf_describe_object_fields(object_name)
}
\arguments{
\item{object_name}{\code{character}; the name of the Salesforce object that the
function is operating against (e.g. "Account", "Contact", "CustomObject__c").}
}
\value{
A \code{tbl_df} containing one row per field for the requested object.
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#maturing'><img src='figures/lifecycle-maturing.svg' alt='Maturing lifecycle'></a>}}{\strong{Maturing}}

This function takes the name of an object in Salesforce and returns a description
of the fields on that object by returning a tibble with one row per field.
}
\note{
The tibble only contains the fields that the user can view, as defined by
the user's field-level security settings.
}
\examples{
\dontrun{
acct_fields <- sf_describe_object_fields('Account')
}
}
