% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create-metadata.R
\name{sf_create_metadata}
\alias{sf_create_metadata}
\title{Create Object or Field Metadata in Salesforce}
\usage{
sf_create_metadata(metadata_type, metadata, all_or_none = FALSE,
  verbose = FALSE)
}
\arguments{
\item{metadata_type}{character; string on what type of metadata to create}

\item{metadata}{\code{list}; metadata components to be created formatted as 
XML before being sent via API}

\item{all_or_none}{logical; allows a call to roll back all changes unless all 
records are processed successfully}

\item{verbose}{logical; do you want informative messages?}
}
\value{
A \code{tbl_df} containing the creation result for each submitted metadata component
}
\description{
This function takes a list of Metadata components and sends them 
to Salesforce for creation
}
\examples{
\dontrun{
# read the metadata of the existing Account object
# we will use this object as a template to create a custom version
metadata_info <- sf_read_metadata(metadata_type='CustomObject',
                                  object_names=c('Account'))
custom_metadata <- metadata_info[[1]]
# remove default actionOverrides, this cannot be set during creation
custom_metadata[which(names(custom_metadata) \%in\% c("actionOverrides"))] <- NULL
# remove fields since its a custom object and the standard ones no longer exist
custom_metadata[which(names(custom_metadata) \%in\% c("fields"))] <- NULL
# remove views so that we get the Standard List Views
custom_metadata[which(names(custom_metadata) \%in\% c("listViews"))] <- NULL
# remove links so that we get the Standard Web Links
custom_metadata[which(names(custom_metadata) \%in\% c("webLinks"))] <- NULL
# now make some adjustments to customize the object
this_label <- 'Custom_Account43'
custom_metadata$fullName <- paste0(this_label, '__c')
custom_metadata$label <- this_label
custom_metadata$pluralLabel <- paste0(this_label, 's')
custom_metadata$nameField <- list(displayFormat='AN-{0000}',
                                  label='Account Number',
                                  type='AutoNumber')
custom_metadata$fields <- list(fullName="Phone__c",
                               label="Phone",
                               type="Phone")
# set the deployment status, this must be set before creation
custom_metadata$deploymentStatus <- 'Deployed'
# make a description to identify this easily in the UI setup tab
custom_metadata$description <- 'created by the Metadata API'
new_custom_object <- sf_create_metadata(metadata_type='CustomObject',
                                        metadata=custom_metadata, verbose=TRUE)

# adding custom fields to our object 
# input formatted as a list
custom_fields <- list(list(fullName='Custom_Account43__c.CustomField66__c',
                           label='CustomField66',
                           length=100,
                           type='Text'),
                      list(fullName='Custom_Account43__c.CustomField77__c',
                           label='CustomField77',
                           length=100,
                           type='Text'))
# formatted as a data.frame
custom_fields <- data.frame(fullName=c('Custom_Account43__c.CustomField88__c',
                                       'Custom_Account43__c.CustomField99__c'),
                            label=c('Test Field1', 'Test Field2'),
                            length=c(44,45),
                            type=c('Text', 'Text'))
new_custom_fields <- sf_create_metadata(metadata_type = 'CustomField', 
                                        metadata = custom_fields)
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/}
}
