% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_safe.R
\name{safe_api_search}
\alias{safe_api_search}
\alias{validate_query_param}
\title{Internal SAFE dataset API search functions}
\usage{
safe_api_search(endpoint, params, ids = NULL, most_recent = FALSE)

validate_query_param(name, val, class = "character", length = 1)
}
\arguments{
\item{endpoint}{The name of the search API endpoint to be used.}

\item{params}{A character vector of the query parameters to be passed  to
the API endpoint.}

\item{ids}{A set of SAFE dataset record IDs to restrict a search. This will
typically be a \code{\link{safe_record_set}} object returned by another search 
but can also be a vector of record ids in any of the formats accepted by 
\code{\link{validate_record_ids}}.}

\item{most_recent}{Logical indicating whether to restrict the API to
returning only the most recent versions of the datasets found. By default
all versions of matching dataset concepts are returned.}

\item{name}{The parameter name}

\item{val}{The user provided input}

\item{class}{Accepted input classes}

\item{length}{Accepted input lengths}
}
\value{
The \code{safe_api_search} function returns an object of class 
   \code{\link{safe_record_set}} of datasets that match the submitted query. The
   \code{validate_query_param} function either returns NULL on success or
   raises an error.
}
\description{
The two internal functions described here handle validating the parameters
passed to the exported search functions and then constructing API calls from
the parameters and the common \code{ids} and \code{most_recent} arguments.
}
\section{Functions}{
\itemize{
\item \code{safe_api_search}: Constructs, submits and formats calls to the SAFE API.

\item \code{validate_query_param}: A basic query parameter validation handler
}}

\keyword{internal}
