% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_diagnostics.R
\name{kurtosis}
\alias{kurtosis}
\title{Kurtosis}
\usage{
kurtosis(x)
}
\arguments{
\item{x}{a numeric vector containing the values whose kurtosis is to be
computed. NA values are removed in the computation.}
}
\value{
The kurtosis of \code{x}.
}
\description{
Computes the kurtosis.
}
\details{
If \eqn{N = \mathrm{length}(x)}{N = length(x)}, then the kurtosis of \eqn{x}
is defined as: \deqn{N sum_i (x_i-\mathrm{mean}(x))^4 (sum_i
(x_i-\mathrm{mean}(x))^2)^(-2) - }{N sum_i (x_i-mean(x))^4 (sum_i
(x_i-mean(x))^2)^(-2) - 3}\deqn{3}{N sum_i (x_i-mean(x))^4 (sum_i
(x_i-mean(x))^2)^(-2) - 3}
}
\examples{
x <- rnorm(100)
kurtosis(x)
}
\references{
G. Snedecor, W. Cochran. \emph{Statistical Methods},
Wiley-Blackwell, 1989
}
\keyword{univar}
