% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mse.R
\name{mse}
\alias{mse}
\alias{mse.fitrfh}
\title{Compute the Mean Squared Error of an Estimator}
\usage{
mse(object, ...)

\method{mse}{fitrfh}(object, type = "pseudo", predType = "reblupbc",
  B = 100, ...)
}
\arguments{
\item{object}{(see methods) an object containing the estimation result, e.g.
\link{rfh}}

\item{...}{arguments passed to methods}

\item{type}{(character) the type of the MSE. Available are 'pseudo' and
'boot'}

\item{predType}{(character) the type of prediction: \code{c("reblup",
"reblupbc")}}

\item{B}{(numeric) number of bootstrap repetitions}
}
\description{
A generic function to compute the mean squared error of the predicted values
under the estimated model. See also \link{rfh} for examples.
}
\details{
Type pseudo is an approximation of the MSE based on a pseudo
linearisation approach by Chambers, et. al. (2011). The specifics can be
found in Warnholz (2016). Type boot implements a parameteric bootstrap for
these methods.
}
\examples{
data("grapes", package = "sae")
data("grapesprox", package = "sae")

fitRFH <- rfh(
  grapehect ~ area + workdays - 1,
  data = grapes,
  samplingVar = "var"
)

mseRFH <- mse(fitRFH)
plot(mseRFH)
}
\references{
Chambers, R., H. Chandra and N. Tzavidis (2011). "On bias-robust mean squared
error estimation for pseudo-linear small area estimators". In: Survey
Methodology 37 (2), pp. 153–170.

Warnholz, S. (2016): "Small Area Estimaiton Using Robust Extension to Area
Level Models". Not published (yet).
}
