% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataBetaAr1.R
\docType{data}
\name{dataBetaAr1}
\alias{dataBetaAr1}
\title{Sample Data under Beta Distribution for Small Area Estimation using Hierarchical Bayesian Method for Rao Yu Model}
\format{
A data frame with 100 rows and 6 variables:
\describe{
  \item{ydi}{Direct Estimation of y}
  \item{area}{Area (domain) of the data}
  \item{period}{Period (subdomain) of the data}
  \item{vardir}{Sampling Variance of y}
  \item{xdi1}{Auxiliary variable of xdi1}
  \item{xdi2}{Auxiliary variable of xdi2}
}
}
\usage{
dataBetaAr1
}
\description{
Dataset under Beta Distribution to simulate Small Area Estimation using Hierarchical Bayesian Method for Rao Yu Model
This data is generated by these following steps:
\enumerate{
\item Generate random effect area \code{v}, random effect for area i at time point j \code{u}, epsilon \eqn{\epsilon}, variance of ydi \code{vardir}, sampling error \code{e}, auxiliary \code{xdi1} and \code{xdi2}
\itemize{
\item Set coefficient \eqn{\beta_{0}=\beta_{1}=\beta_{2}=2} and \eqn{\rho = -0,5}
\item Generate random effect area \code{v_{i}~N(0,1)}
\item Generate auxiliary variable \code{xdi1_{ij}~U(0,1)}
\item Generate auxiliary variable \code{xdi2_{ij}~U(0,1)}
\item Generate epsilon \eqn{\epsilon_{ij}}\code{~N(0,1)}
\item Generate sampling error \code{e_{ij}~N(0,vardir_{ij})}
\item Generate  \eqn{\phi_{ij}}\code{~Gamma(1,0.5)}
\item Calculate random effect for area i at time point j \eqn{u_{ij}=\rho*u_{ij-1}+\epsilon_{ij}}
\item Calculate \eqn{\mu_{ij}=\frac{(\exp{\beta_{0}+\beta_{1}xdi1_{ij}+\beta_{2}xdi2_{ij}+v_{i}+\epsilon_{ij}})}{(1+\exp{\beta_{0}+\beta_{1}xdi1_{ij}+\beta_{2}xdi2_{ij}+v_{i}+\epsilon_{ij}}})}
\item Calculate \eqn{A_{ij}=\mu_{ij}*\phi_{ij}}
\item Calculate \eqn{B_{ij}=(1-\mu_{ij})*\phi_{ij}}
\item Generate ydi \code{y_{ij}~Beta(A_{ij},B_{ij})}
\item Calculate variance of ydi with \eqn{vardir_{ij}=\frac{(A_{ij})(B_{ij})}{(A_{ij}+B_{ij})^2(A_{ij}+B_{ij}+1)}}
\item Set \code{area=20} and \code{period=5}
}
\item Auxiliary variables \code{xdi1,xdi2}, direct estimation \code{y}, \code{area}, \code{period}, and \code{vardir} are combined in a dataframe called \code{dataAr1}
}
}
\keyword{datasets}
