% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meHBbeta.R
\name{meHBbeta}
\alias{meHBbeta}
\title{Small Area Estimation with Measurement Error using Hierarchical Bayesian Method under Beta Distribution}
\usage{
meHBbeta(
  formula,
  var.x,
  coef,
  var.coef,
  iter.update = 3,
  iter.mcmc = 10000,
  thin = 2,
  tau.u = 1,
  burn.in = 2000,
  data
)
}
\arguments{
\item{formula}{an object of class \code{\link[stats]{formula}} (or one that can be coerced to that class): a symbolic description of the model to be fitted. The variables included \code{formula} must have a length equal to the number of domains \code{m}. This formula can provide auxiliary variable either measured with error or combination between measured with \code{error} and \code{without error}. If the auxiliary variable are combination between \code{error} and \code{without error}, input the \code{error} variable first followed by \code{without error} variable.}

\item{var.x}{vector containing mean squared error of \code{X}. The values must be sorted as the \code{X}.}

\item{coef}{a vector contains prior initial value of Coefficient of Regression Model for fixed effect with default vector of \code{0} with the length of the number of regression coefficients.}

\item{var.coef}{a vector contains prior initial value of variance of Coefficient of Regression Model with default vector of \code{1} with the length of the number of regression coefficients.}

\item{iter.update}{number of updates with default \code{3}.}

\item{iter.mcmc}{number of total iterations per chain with default \code{10000}.}

\item{thin}{thinning rate, must be a positive integer with default \code{3}.}

\item{tau.u}{prior initial value of inverse of Variance of area random effect with default \code{1}.}

\item{burn.in}{burn.in number of iterations to discard at the beginning with default \code{2000}.}

\item{data}{the data frame.}
}
\value{
This function returns a list with the following objects:
\item{Est}{A vector with the values of Small Area mean Estimates using Hierarchical bayesian method }
\item{refvar}{Estimated random effect variances}
\item{coefficient}{A data frame with the estimated model coefficient}
\item{plot}{Trace, Dencity, Autocorrelation Function Plot of MCMC samples}
}
\description{
This function is implemented to variable of interest \eqn{(Y)} that assumed to be a Beta Distribution when auxiliary variable is measured with error. The range of data must be \eqn{0<Y<1}. The data proportion is supposed to be implemented with this function.
}
\examples{
## it may take time
## Load dataset
data(dataHBMEbeta)

## Auxiliary variables only contains variable with error in aux variable
example <- meHBbeta(Y~x1+x2, var.x = c("v.x1","v.x2"),
                   iter.update = 3, iter.mcmc = 1010,
                   thin = 1, burn.in = 1000, data = dataHBMEbeta)

## you can use dataHBMEbetaNS for using dataset with non-sampled area
## and you can use this function for aux variables contains variable with error and without error

}
