% Generated by roxygen2 (4.0.2): do not edit by hand
\name{calculate.summary}
\alias{calculate.summary}
\title{Calculate Summary Statistics for a Set of Fixations.}
\usage{
calculate.summary(fixations)
}
\arguments{
\item{fixations}{a data frame containing the fixations that were
detected in the samples.  See
\code{\link[saccades]{detect.fixations}} for details about the
format.}
}
\value{
A data frame containing the statistics.
}
\description{
Calculates summary statistics about the trials and fixations in the
given data frame.
}
\section{Details}{
 Calculates the number of trials, the average
duration of trials, the average number of fixations in trials, the
average duration of the fixations, the average spatial dispersion
in the fixations, and the average peak velocity that occurred
during fixations.  Where appropriate standard deviations are given
as well.  Use round to obtain a more readable version of
the resulting data frame.
}
\examples{
data(fixations)
stats <- calculate.summary(fixations)
round(stats, digits=2)
}
\author{
Titus von der Malsburg \email{malsburg@posteo.de}
}
\seealso{
\code{\link{diagnostic.plot}},
\code{\link{detect.fixations}}
}

