% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_system_async.R
\name{s3_file_move_async}
\alias{s3_file_move_async}
\title{Move or rename S3 files}
\usage{
s3_file_move_async(
  path,
  new_path,
  max_batch = 100 * MB,
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{path}{(character): A character vector of s3 uri}

\item{new_path}{(character): A character vector of s3 uri.}

\item{max_batch}{(numeric): Maximum batch size being uploaded with each multipart.}

\item{overwrite}{(logical): Overwrite files if the exist. If this is \code{FALSE}
and the file exists an error will be thrown.}

\item{...}{parameters to be passed to \code{\link[paws.storage]{s3_copy_object}}}
}
\value{
return \code{\link[future]{future}} object of \code{\link[=s3_file_move]{s3_file_move()}}
}
\description{
Move files to another location on AWS S3
}
\seealso{
\code{\link[future]{future}} \code{\link[=s3_file_move]{s3_file_move()}}
}
