% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_system.R
\name{info}
\alias{info}
\alias{s3_file_info}
\alias{s3_file_size}
\alias{s3_dir_info}
\alias{s3_dir_ls}
\title{Get files and directories information}
\usage{
s3_file_info(path)

s3_file_size(path)

s3_dir_info(
  path = ".",
  type = c("any", "bucket", "directory", "file"),
  glob = NULL,
  regexp = NULL,
  invert = FALSE,
  recurse = FALSE,
  refresh = FALSE,
  ...
)

s3_dir_ls(
  path = ".",
  type = c("any", "bucket", "directory", "file"),
  glob = NULL,
  regexp = NULL,
  invert = FALSE,
  recurse = FALSE,
  refresh = FALSE,
  ...
)
}
\arguments{
\item{path}{(character):A character vector of one or more paths. Can be path
or s3 uri.}

\item{type}{(character): File type(s) to return. Default ("any") returns all
AWS S3 object types.}

\item{glob}{(character): A wildcard pattern (e.g. \code{*.csv}), passed onto
\code{grep()} to filter paths.}

\item{regexp}{(character): A regular expression (e.g. \code{[.]csv$}),
passed onto \code{grep()} to filter paths.}

\item{invert}{(logical): If \code{code} return files which do not match.}

\item{recurse}{(logical): Returns all AWS S3 objects in lower sub directories}

\item{refresh}{(logical): Refresh cached in \code{s3_cache}.}

\item{...}{parameters to be passed to \code{\link[paws.storage]{s3_list_objects_v2}}}
}
\value{
\code{s3_file_info} A data.table with metadata for each file. Columns returned are as follows.
\itemize{
\item{bucket_name (character): AWS S3 bucket of file}
\item{key (character): AWS S3 path key of file}
\item{uri (character): S3 uri of file}
\item{size (numeric): file size in bytes}
\item{type (character): file type (file or directory)}
\item{etag (character): An entity tag is an opague identifier}
\item{last_modified (POSIXct): Created date of file.}
\item{delete_marker (logical): Specifies retrieved a logical marker}
\item{accept_ranges (character): Indicates that a range of bytes was specified.}
\item{expiration (character): File expiration}
\item{restore (character): If file is archived}
\item{archive_status (character): Archive status}
\item{missing_meta (integer): Number of metadata entries not returned in "x-amz-meta" headers}
\item{version_id (character): version id of file}
\item{cache_control (character): caching behaviour for the request/reply chain}
\item{content_disposition (character): presentational information of file}
\item{content_encoding (character): file content encodings}
\item{content_language (character): what language the content is in}
\item{content_type (character): file MIME type}
\item{expires (POSIXct): date and time the file is no longer cacheable}
\item{website_redirect_location (character): redirects request for file to another}
\item{server_side_encryption (character): File server side encryption}
\item{metadata (list): metadata of file}
\item{sse_customer_algorithm (character): server-side encryption with a customer-provided encryption key}
\item{sse_customer_key_md5 (character): server-side encryption with a customer-provided encryption key}
\item{ssekms_key_id (character): ID of the Amazon Web Services Key Management Service}
\item{bucket_key_enabled (logical): s3 bucket key for server-side encryption with}
\item{storage_class (character): file storage class information}
\item{request_charged (character): indicates successfully charged for request}
\item{replication_status (character): return specific header if request
involves a bucket that is either a source or a destination in a replication rule
\url{https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/s3.html#S3.Client.head_object}}
\item{parts_count (integer): number of count parts the file has}
\item{object_lock_mode (character): the file lock mode}
\item{object_lock_retain_until_date (POSIXct): date and time of when object_lock_mode expires}
\item{object_lock_legal_hold_status (character): file legal holding}
}

\code{s3_dir_info} data.table with directory metadata
\itemize{
\item{bucket_name (character): AWS S3 bucket of file}
\item{key (character): AWS S3 path key of file}
\item{uri (character): S3 uri of file}
\item{size (numeric): file size in bytes}
\item{version_id (character): version id of file}
\item{etag (character): An entity tag is an opague identifier}
\item{last_modified (POSIXct): Created date of file}
}

\code{s3_dir_ls} character vector of s3 uri paths
}
\description{
\code{s3_file_info} returns file information within AWS S3 directory

\code{s3_file_size} returns file size in bytes

\code{s3_dir_info} returns file name information within AWS S3 directory

\code{s3_dir_ls} returns file name within AWS S3 directory
}
\examples{
\dontrun{
# Require AWS S3 credentials

temp_file = s3_file_temp(tmp_dir= "MyBucket")
s3_file_create(temp_file)

s3_file_info(temp_file)
}
}
