% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProjectField.R
\name{ProjectField}
\alias{ProjectField}
\title{Project anomalies onto modes of variability}
\usage{
ProjectField(
  ano,
  eof,
  time_dim = "sdate",
  space_dim = c("lat", "lon"),
  mode = NULL,
  ncores = NULL
)
}
\arguments{
\item{ano}{A numerical array of anomalies with named dimensions. The 
dimensions must have at least 'time_dim' and 'space_dim'. It can be
generated by Ano().}

\item{eof}{A list that contains at least 'EOFs' or 'REOFs' and 'wght', which 
are both arrays. 'EOFs' or 'REOFs' must have dimensions 'mode' and 
'space_dim' at least. 'wght' has dimensions space_dim. It can be generated 
by EOF() or REOF().}

\item{time_dim}{A character string indicating the name of the time dimension
of 'ano'. The default value is 'sdate'.}

\item{space_dim}{A vector of two character strings. The first is the dimension
name of latitude of 'ano' and the second is the dimension name of longitude
of 'ano'. The default value is c('lat', 'lon').}

\item{mode}{An integer of the variability mode number in the EOF to be 
projected on. The default value is NULL, which means all the modes of 'eof'
is calculated.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
A numerical array of the principal components in the verification 
 format. The dimensions are the same as 'ano' except 'space_dim'.
}
\description{
Project anomalies onto modes of variability to get the temporal evolution of 
the EOF mode selected. It returns principal components (PCs) by area-weighted
projection onto EOF pattern (from \code{EOF()}) or REOF pattern (from 
\code{REOF()} or \code{EuroAtlanticTC()}). The calculation removes NA and 
returns NA if the whole spatial pattern is NA.
}
\examples{
\dontshow{
startDates <- c('19851101', '19901101', '19951101', '20001101', '20051101')
sampleData <- s2dv:::.LoadSampleData('tos', c('experiment'),
                                    c('observation'), startDates,
                                    leadtimemin = 1,
                                    leadtimemax = 4,
                                    output = 'lonlat',
                                    latmin = 27, latmax = 48,
                                    lonmin = -12, lonmax = 40)
}
ano <- Ano_CrossValid(sampleData$mod, sampleData$obs)
eof_exp <- EOF(ano$exp, sampleData$lat, sampleData$lon) 
eof_obs <- EOF(ano$obs, sampleData$lat, sampleData$lon) 
mode1_exp <- ProjectField(ano$exp, eof_exp, mode = 1)
mode1_obs <- ProjectField(ano$obs, eof_obs, mode = 1)

\dontrun{
 # Plot the forecast and the observation of the first mode for the last year 
 # of forecast
 sdate_dim_length <- dim(mode1_obs)['sdate']
 plot(mode1_obs[sdate_dim_length, 1, 1, ], type = "l", ylim = c(-1, 1), 
      lwd = 2)
 for (i in 1:dim(mode1_exp)['member']) {
   par(new = TRUE)
   plot(mode1_exp[sdate_dim_length, 1, i, ], type = "l", col = rainbow(10)[i], 
        ylim = c(-15000, 15000))
 }
}

}
\seealso{
EOF, NAO, PlotBoxWhisker
}
