% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Filter.R
\name{Filter}
\alias{Filter}
\title{Filter frequency peaks from an array}
\usage{
Filter(data, freq, time_dim = "ftime", ncores = NULL)
}
\arguments{
\item{data}{A numeric vector or array of the data to be filtered. 
If it's a vector, it should be a time series. If it's an array,
the  dimensions must have at least 'time_dim'.}

\item{freq}{A number of the frequency to filter.}

\item{time_dim}{A character string indicating the dimension along which to 
compute the filtering. The default value is 'ftime'.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
A numeric vector or array of the filtered data with the dimensions
 the same as 'data'.
}
\description{
Filter out the selected frequency from a time series. The filtering is 
performed by dichotomy, seeking for a frequency around the parameter 'freq'
and the phase that maximizes the signal to subtract from the time series.
The maximization of the signal to subtract relies on a minimization of the 
mean square differences between the time series ('data') and the cosine of 
the specified frequency and phase.
}
\examples{
# Load sample data as in Load() example:
example(Load)
ensmod <- MeanDims(sampleData$mod, 2)
spectrum <- Spectrum(ensmod)

for (jsdate in 1:dim(spectrum)['sdate']) {
 for (jlen in 1:dim(spectrum)['ftime']) {
   if (spectrum[jlen, 2, 1, jsdate] > spectrum[jlen, 3, 1, jsdate]) {
     ensmod[1, jsdate, ] <- Filter(ensmod[1, jsdate, ], spectrum[jlen, 1, 1, jsdate])
   }
 }
}
 \donttest{
PlotAno(InsertDim(ensmod, 2, 1), sdates = startDates)
 }

}
