% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/geolookup.R
\name{geolookup}
\alias{geolookup}
\title{Lists nearby weather stations for a given location}
\usage{
geolookup(location, use_metric = FALSE, key = get_api_key(), raw = FALSE,
  message = TRUE)
}
\arguments{
\item{location}{location set by set_location}

\item{use_metric}{Metric or imperial units}

\item{key}{weather underground API key}

\item{raw}{if TRUE return raw httr object}

\item{message}{if TRUE print out requested URL}
}
\value{
tbl_df of nearby weather stations with:
        type, city, state, country, id, lat, lon and
        dist (in either mi or km)
}
\description{
Lists nearby weather stations for a given location
}
\examples{
\dontrun{
geolookup(set_location(territory = "Hawaii", city = "Honolulu"))
geolookup(set_location(airport_code = "SEA"))
geolookup(set_location(zip_code = "90210"))
geolookup(set_location(territory = "IR", city = "Tehran"))
}
}

