% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_dockerfile.R
\name{use_dockerfile}
\alias{use_dockerfile}
\title{Use Dockerfile}
\usage{
use_dockerfile(
  save_dir = here::here(),
  path = file.path(save_dir, "Dockerfile"),
  force_new = FALSE,
  show = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{save_dir}{Directory to save the Docker file to.}

\item{path}{Path to the Docker file.}

\item{force_new}{If a Docker file already exists, overwrite it 
(default: \code{FALSE}).}

\item{show}{Print the contents of the Docker file in the R console.}

\item{verbose}{Print messages.}
}
\value{
Path to Docker file.
}
\description{
Creates a Docker file to be used with the GitHub Actions (GHA) workflows
distributed by \pkg{rworkflows}.
}
\examples{
path <- use_dockerfile(save_dir=tempdir())
}
