% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/rwirelesscom.R
\name{f64qamdemod}
\alias{f64qamdemod}
\title{64-QAM Demodulator}
\usage{
f64qamdemod(r)
}
\arguments{
\item{r}{- complex valued input vector}
}
\value{
a vector of 1's and 0's, 6 bits per input element (64-QAM symbol)
}
\description{
Receives a vector of complex values, r, corresponding to a
64-QAM modulated signal transmitted through a communications channel
(e.g., signal plus noise). Each received 64-QAM symbol (one symbol per r sample) is decoded into
6 bits. The 64-QAM symbol decision regions are defined with respect to
the constellation generated by f64qammod(), where in-phase and quadrature
constellation points take on values -7, -5, -3, -1, +1, +3, +5, +7, respectively.
}
\examples{
M=64
Es=42
Eb = Es/log2(M)
Nsymbols=1000
Nbits=log2(M)*Nsymbols
bits <- sample(0:1,Nbits, replace=TRUE)
s <- f64qammod(bits)
EbNodB=12
No = Eb/(10^(EbNodB/10))
n <- fNo(Nsymbols,No,type="complex")
r <- s+n
bitsr <- f64qamdemod(r)
biterrs<-bits[bitsr!=bits]
Pberr=length(biterrs)/length(bits)
}
\seealso{
Other rwirelesscom functions: \code{\link{eyediagram}};
  \code{\link{f16pskdemod}}; \code{\link{f16pskmod}};
  \code{\link{f16qamdemod}}; \code{\link{f16qammod}};
  \code{\link{f64qammod}}; \code{\link{f8pskdemod}};
  \code{\link{f8pskmod}}; \code{\link{fNo}};
  \code{\link{fbpskdemod}}; \code{\link{fbpskmod}};
  \code{\link{fqpskdemod}}; \code{\link{iqdensityplot}};
  \code{\link{iqscatterplot}}; \code{\link{stemplot}}
}

