% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FWT_TI.R
\name{FWT_TI}
\alias{FWT_TI}
\title{Translation Invariant Forward Wavelet Transform.}
\usage{
FWT_TI(x, L, qmf)
}
\arguments{
\item{x}{array of dyadic length n=2^J.}

\item{L}{degree of coarsest scale.}

\item{qmf}{orthonormal quadrature mirror filter.}
}
\value{
\code{TIWT} stationary wavelet transform table.
}
\description{
1. \code{qmf} filter may be obtained from \code{\link{MakeONFilter}}.
2. usually, \code{length(qmf) < 2^(L+1)}.
3. To reconstruct use \code{\link{IWT_TI}}.
}
\examples{
x <- MakeSignal('Ramp', 8)
L <- 0
qmf <- MakeONFilter('Haar')
TIWT <- FWT_TI(x, L, qmf)
}
\seealso{
\code{\link{IWT_TI}}, \code{\link{MakeONFilter}}.
}
