% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xl_add_vg.R
\name{xl_add_vg}
\alias{xl_add_vg}
\title{add a plot output as vector graphics into an Excel object}
\usage{
xl_add_vg(x, sheet, code, left, top, width, height, ...)
}
\arguments{
\item{x}{an \code{rxlsx} object produced by \code{officer::read_xlsx}}

\item{sheet}{sheet label/name}

\item{code}{plot instructions}

\item{left, top}{left and top origin of the plot on the slide in inches.}

\item{height, width}{Height and width in inches.}

\item{...}{arguments passed on to \code{\link{dml_xlsx}}.}
}
\description{
produces a vector graphics output from R plot instructions
and add the result in an Excel sheet.
by \code{\link[officer]{read_xlsx}}.
}
\examples{
\donttest{
library(officer)
my_ws <- read_xlsx()
my_ws <- xl_add_vg(my_ws, sheet = "Feuil1",
  code = barplot(1:5, col = 2:6), width = 6, height = 6, left = 1, top = 2 )
fileout <- tempfile(fileext = ".xlsx")
print(my_ws, target = fileout)
}
}
