% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html.R
\name{html_attr}
\alias{html_attr}
\alias{html_attrs}
\title{Get element attributes}
\usage{
html_attr(x, name, default = NA_character_)

html_attrs(x)
}
\arguments{
\item{x}{A document (from \code{\link[=read_html]{read_html()}}), node set (from \code{\link[=html_elements]{html_elements()}}),
node (from \code{\link[=html_element]{html_element()}}), or session (from \code{\link[=session]{session()}}).}

\item{name}{Name of attribute to retrieve.}

\item{default}{A string used as a default value when the attribute does
not exist in every element.}
}
\value{
A character vector (for \code{html_attr()}) or list (\code{html_attrs()})
the same length as \code{x}.
}
\description{
\code{html_attr()} gets a single attribute; \code{html_attr()} gets all attributes.
}
\examples{
url <- "https://en.wikipedia.org/w/index.php?title=The_Lego_Movie&oldid=998422565"
html <- read_html(url)

cast <- html_elements(html, "tr:nth-child(8) .plainlist a")
cast \%>\% html_text2()
cast \%>\% html_attrs()
cast \%>\% html_attr("href")

# If needed, use url_absolute() to convert to complete urls
url_absolute(html_attr(cast, "href"), url)
}
