### R code from vignette source 'rv-doc.Rnw'

###################################################
### code chunk number 1: rv-doc.Rnw:59-61
###################################################
  set.seed(20100129)
options(digits=2)


###################################################
### code chunk number 2: rv-doc.Rnw:101-102
###################################################
    library(rv)


###################################################
### code chunk number 3: rv-doc.Rnw:118-119
###################################################
setnsims(4000)


###################################################
### code chunk number 4: rv-doc.Rnw:131-132
###################################################
x <- rvnorm(mean=1:5, sd=1)


###################################################
### code chunk number 5: rv-doc.Rnw:146-147
###################################################
  x


###################################################
### code chunk number 6: rv-doc.Rnw:154-155
###################################################
  y <- rvpois(lambda=10)


###################################################
### code chunk number 7: rv-doc.Rnw:166-172
###################################################
rvmean(x)
rvsd(x)
rvquantile(x, c(0.025,0.25,0.5,0.75,0.975))
rvmedian(x)
rvmin(y)
rvmax(y)


###################################################
### code chunk number 8: rv-doc.Rnw:199-201
###################################################
x[3:4] <- rvbinom(size=1, prob=c(0.1,0.9))
x[3:4]


###################################################
### code chunk number 9: rv-doc.Rnw:211-214
###################################################
y <- as.rv(1:5)
y[3:4] <- x[3:4]
y


###################################################
### code chunk number 10: rv-doc.Rnw:218-221
###################################################
y <- (1:5)
impute(y, 3:4) <- x[3:4]
y


###################################################
### code chunk number 11: rv-doc.Rnw:238-239
###################################################
1/(1+exp(-x[1]))


###################################################
### code chunk number 12: rv-doc.Rnw:242-243
###################################################
2*log(abs(x[2]))


###################################################
### code chunk number 13: rv-doc.Rnw:250-255
###################################################
x <- rvpois(lambda=1:5)
x
sort(x)
min(x)
max(x)


###################################################
### code chunk number 14: rv-doc.Rnw:273-278
###################################################
p <- runif(4) # Some prior probabilities.
y <- rvbinom(size=1, prob=p) # y is now a rv of length 4.
dim(y) <- c(2,2) # Make y into a 2x2 matrix.
y
y %**% y


###################################################
### code chunk number 15: rv-doc.Rnw:283-284
###################################################
E(y)


###################################################
### code chunk number 16: rv-doc.Rnw:292-294
###################################################
z <- rvnorm(1)
z > 1


###################################################
### code chunk number 17: rv-doc.Rnw:299-300
###################################################
Pr(z > 1)


###################################################
### code chunk number 18: rv-doc.Rnw:306-308
###################################################
z <- rvnorm(2)
Pr(z[1] > z[2]^2)


###################################################
### code chunk number 19: rv-doc.Rnw:311-313
###################################################
Pr(x[1] > x[2] & x[1] > x[4])
Pr(x[1] > x[2] | x[1] > x[4])


###################################################
### code chunk number 20: rv-doc.Rnw:326-332
###################################################
z <- rvnorm(n=2, mean=0, sd=1)
y <- exp(z)
y[2] <- y[2] * y[1]
x <- (y[1]-1) * (y[1]>1) * (y[2]>1)
E(x)
Pr(x>1)


###################################################
### code chunk number 21: rv-doc.Rnw:342-350
###################################################
  n <- 10
  ## Some covariates
  X <- data.frame(x1=rnorm(n, mean=0), x2=rpois(n, 10) - 10)
  y.mean <- (1.0 + 2.0 * X$x1 + 3.0 * X$x2)
  y <- rnorm(n, y.mean, sd=1.5) ## n random numbers
  D <- cbind(data.frame(y=y), X)
  ## Regression model fit
  fit <- lm(y ~ x1 + x2, data=D)


###################################################
### code chunk number 22: rv-doc.Rnw:353-355
###################################################
  Post <- posterior(fit)
  Post


###################################################
### code chunk number 23: rv-doc.Rnw:371-376
###################################################
sigma <- Post$sigma
betas <- Post$beta
M <- model.matrix(fit)
y.rep <- rvnorm(mean=M %**% betas, sd=sigma)
mlplot(y.rep) # Summarize graphically.


###################################################
### code chunk number 24: rv-doc.Rnw:382-383
###################################################
M %**% betas


###################################################
### code chunk number 25: rv-doc.Rnw:395-397
###################################################
  ## Replications
  y.rep <- rvpredict(fit)


###################################################
### code chunk number 26: rv-doc.Rnw:401-404
###################################################
  ## Predictions at the mean of the covariates
  X.pred <- data.frame(x1=mean(X$x1), x2=mean(X$x2))
  y.pred <- rvpredict(fit, newdata=X.pred)


###################################################
### code chunk number 27: rv-doc.Rnw:409-413
###################################################
  X.rep <- X
  X.rep$x1 <- rnorm(n=n, mean=X.rep$x1, sd=sd(X.rep$x1))
  y.pred2 <- rvpredict(fit, newdata=X.rep)
  y.pred2


###################################################
### code chunk number 28: rv-doc.Rnw:439-442
###################################################
  ## Plot predictions
  plot.rv(D$y, y.rep, rvcol="red")
  points.rv(D$y + 0.33, y.pred2, rvcol="blue")


###################################################
### code chunk number 29: rv-doc.Rnw:452-454
###################################################
  mlplot(y.rep, rvcol="red")
  mlplot(D$y, add=TRUE, col="blue", pch="x")


###################################################
### code chunk number 30: rv-doc.Rnw:459-461
###################################################
rvhist(rvnorm(mean=0, sd=1)^3, xlim=c(-3, 3), 
  col="red", main="Cubed standard normal")


###################################################
### code chunk number 31: <
###################################################
  x <- 1
  for (n in 1:100) {
    x <- x + rvbern(n=1, prob=x / (n + 1))
  }


###################################################
### code chunk number 32: rv-doc.Rnw:488-489
###################################################
  rvhist(x / (n + 1)) # Histogram


###################################################
### code chunk number 33: rv-doc.Rnw:500-502
###################################################
s <- sims(y.rep)
dim(s)


###################################################
### code chunk number 34: rv-doc.Rnw:513-514
###################################################
y <- rvsims(s)


