% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCA_Server.R
\name{NCA_fetch_current_obj}
\alias{NCA_fetch_current_obj}
\title{Fetches the Current Analysis Object}
\usage{
NCA_fetch_current_obj(state, obj_type)
}
\arguments{
\item{state}{NCA state from \code{NCA_fetch_state()}}

\item{obj_type}{Type of object to return (either "table" or "figure").}
}
\value{
List with a format that depends on the obj_type.
For figures:
\itemize{
\item{ggplot:}   ggplot object of the figure.
\item{isgood:}   Return status of the function.
\item{msgs:}     Messages to be passed back to the user.
}
For tables:
\itemize{
\item{df:}       Dataframe of the current table.
\item{ft:}       Flextable object of the current table.
\item{notes:}    Any table notes to be included.
\item{isgood:}   Return status of the function.
\item{msgs:}     Messages to be passed back to the user.
}
}
\description{
Takes the current state and object type and returns the
currently selected object. For example if you have specified figure, it will
look at the output figure selected and the figure number of that figure and
return the ggplot object for that.
by subject id highlighting of certain NCA aspects (e.g. points used for half-life)
}
\examples{
# We need a state object to use below
sess_res = NCA_test_mksession(session=list(), full_session=FALSE)
state = sess_res$state

# Current active table:
res = NCA_fetch_current_obj(state, "table")
res$ft

# Current active figure:
res = NCA_fetch_current_obj(state, "figure")
res$ggplot
}
