% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midas_functions.R
\name{GM_long_run_vol}
\alias{GM_long_run_vol}
\title{GARCH-MIDAS (daily) long-run (with skewness)}
\usage{
GM_long_run_vol(param, daily_ret, mv_m, K, lag_fun = "Beta")
}
\arguments{
\item{param}{Vector of estimated values.}

\item{daily_ret}{Daily returns, which must be an "xts" object.}

\item{mv_m}{MIDAS variable already transformed into a matrix, through \code{\link{mv_into_mat}} function.}

\item{K}{Number of (lagged) realizations of the MIDAS variable to consider.}

\item{lag_fun}{\strong{optional}. Lag function to use. Valid choices are "Beta" (by default) and "Almon",
for the Beta and Exponential Almon lag functions, respectively.}
}
\value{
The resulting vector is an "xts" object representing the conditional volatility.
}
\description{
Obtains the estimated daily long-run volatility for the GARCH-MIDAS model, with an asymmetric term linked to past negative returns.
For details, see \insertCite{engle_ghysels_sohn_2013;textual}{rumidas} and \insertCite{conrad_lock_2015;textual}{rumidas}.
}
\examples{
# estimated volatility
# est_val<-c(alpha=0.01,beta=0.8,gamma=0.05,m=2,theta=0.1,w2=2)
# r_t<-sp500['/2010']
# mv_m<-mv_into_mat(r_t,diff(indpro),K=12,"monthly")
# head(GM_long_run_vol(est_val,r_t,mv_m,K=12))
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{mv_into_mat}}.
}
\keyword{internal}
