% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expose-helpers.R
\name{bind_exposures}
\alias{bind_exposures}
\title{Bind exposures}
\usage{
bind_exposures(..., .validate_output = TRUE)
}
\arguments{
\item{...}{Exposures to bind.}

\item{.validate_output}{Whether to validate with \code{\link[=is_exposure]{is_exposure()}} if the
output is exposure.}
}
\description{
Function to bind several exposures into one.
}
\details{
\strong{Note} that the output might not have names in list-column \code{fun}
in \link[=packs_info]{packs info}, which depends on version of
\link[dplyr:dplyr-package]{dplyr} package.
}
\examples{
my_data_packs <- data_packs(
  data_dims = . \%>\% dplyr::summarise(nrow_low = nrow(.) < 10),
  data_sum = . \%>\% dplyr::summarise(sum = sum(.) < 1000)
)

ref_exposure <- mtcars \%>\% expose(my_data_packs) \%>\% get_exposure()

exposure_1 <- mtcars \%>\% expose(my_data_packs[1]) \%>\% get_exposure()
exposure_2 <- mtcars \%>\% expose(my_data_packs[2]) \%>\% get_exposure()
exposure_binded <- bind_exposures(exposure_1, exposure_2)

exposure_pipe <- mtcars \%>\%
  expose(my_data_packs[1]) \%>\% expose(my_data_packs[2]) \%>\%
  get_exposure()

identical(exposure_binded, ref_exposure)

identical(exposure_pipe, ref_exposure)

}
