% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_bookmarks.R
\name{user_bookmarks}
\alias{user_bookmarks}
\title{Retrieve user bookmarks}
\usage{
user_bookmarks(
  id,
  n = 100,
  ...,
  expansions = NULL,
  fields = NULL,
  parse = TRUE,
  token = NULL,
  verbose = FALSE
)
}
\arguments{
\item{id}{Twitter user id: character string identifying your account.}

\item{n}{Number of tweets to retrieve.}

\item{...}{Other arguments passed down to the API.}

\item{expansions}{Set \code{NULL} to not use any expansion, set \code{NA} to get all
expansions, or provide a vector with the expansions you want (create it with
\code{\link[=set_expansions]{set_expansions()}}).}

\item{fields}{Set \code{NULL} to not use any field, get all allowed fields with \code{NA},
provide a list with the fields you want (create it with \code{\link[=set_fields]{set_fields()}}).}

\item{parse}{If \code{TRUE}, the default, returns a tidy data frame. Use \code{FALSE}
to return the "raw" list corresponding to the JSON returned from the
Twitter API.}

\item{token}{This endpoint only accept a OAuth2.0 authentication (can be
created via \code{\link[=rtweet_oauth2]{rtweet_oauth2()}}).}

\item{verbose}{A logical value}
}
\value{
A data.frame with the user information of who is following the list:
edit_history_tweet_ids, id and text.
Other information depends on the \code{expansions} and \code{fields} requested.
Accepted values are:
\itemize{
\item Expansions: \code{set_expansions(list = NULL)}.
\item Fields: \code{set_fields(list = NULL)}.
}
}
\description{
Collects the 800 most recent bookmarked tweets of a user.
}
\note{
This endpoint requires a OAuth2.0 authentication, with tweet.read, users.read and bookmark.read permissions.
}
\examples{
if (FALSE) {
   # Requires token_oa2
   ub <- user_bookmarks(user_self()$id, parse = FALSE, n = Inf, token = token_oa2)
}
}
\references{
\url{https://developer.twitter.com/en/docs/twitter-api/tweets/bookmarks/api-reference/get-users-id-bookmarks}
}
\seealso{
\code{\link[=rtweet_oauth2]{rtweet_oauth2()}}, \code{\link[=user_self]{user_self()}}
}
