% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{auth_setup_default}
\alias{auth_setup_default}
\alias{auth_has_default}
\title{Set up default authentication}
\usage{
auth_setup_default()

auth_has_default()
}
\value{
\code{auth_setup_default()}: Invisibly returns the previous authentication mechanism.
\code{auth_has_default()}: A logical value \code{TRUE} if there is a default authentication.
}
\description{
You'll need to run this function once per computer so that rtweet can use
your personal Twitter account. See \code{\link[=rtweet_app]{rtweet_app()}}/\link{rtweet_bot} and
\code{\link[=auth_save]{auth_save()}} for other authentication options.
}
\details{
It will use the current logged in account on the default browser to detect
the credentials needed for rtweet and save them as "default".
If a default is found it will use it instead.
}
\examples{
\dontrun{
if (!auth_has_default() && interactive()) {
   auth_setup_default()
}
}
}
\seealso{
Other authentication: 
\code{\link{auth_as}()},
\code{\link{auth_get}()},
\code{\link{auth_save}()},
\code{\link{rtweet_user}()}
}
\concept{authentication}
