% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_mcmlrts.R
\name{predict.grid}
\alias{predict.grid}
\title{Extract predictions from a \code{grid} object}
\usage{
\method{predict}{grid}(
  object,
  type = c("pred", "rr", "irr"),
  irr.lag = NULL,
  t.lag = 0,
  popdens = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{A \code{grid} object.}

\item{type}{Vector of character strings. Any combination of "pred", "rr", and "irr", which are,
posterior mean incidence (overall and population standardised), relative risk,
and incidence rate ratio, respectively.}

\item{irr.lag}{integer. If "irr" is requested as \code{type} then the number of time
periods lag previous the ratio is in comparison to}

\item{t.lag}{integer. Extract predictions for previous time periods.}

\item{popdens}{character string. Name of the column in \code{grid_data} with the
population density data}

\item{verbose}{Logical indicating whether to print messages to the console}

\item{...}{Further arguments passed from other methods}
}
\value{
An \code{sf} object in which the predictions are stored.
}
\description{
Extract incidence and relative risk predictions. The predictions will be extracted from the last model fit in the \code{grid} object.
If no previous model fit then use either \code{grid$lgcp_ml()} or \code{grid$lgcp_bayes()}, or see \code{grid$model_fit()} to update the stored model fit.
}
\details{
Three outputs can be extracted from the model fit:

Predicted incidence: If type includes \code{pred} then \code{pred_mean_total} and
\code{pred_mean_total_sd} provide the
predicted mean total incidence and its standard deviation, respectively.
\code{pred_mean_pp} and \code{pred_mean_pp_sd} provide the predicted population
standardised incidence and its standard deviation. These are added to the grid data or to the
regional data for spatially-aggregated data.

Relative risk: if type includes \code{rr} then the relative risk is reported in
the columns \code{rr} and \code{rr_sd}. The relative risk here is the exponential
of the latent field, which describes the relative difference between
expected mean and predicted mean incidence. These are added to the grid data.

Incidence risk ratio: if type includes \code{irr} then the incidence rate ratio (IRR)
is reported in the columns \code{irr} and \code{irr_sd}. This is the ratio of the predicted
incidence in the last period (minus \code{t_lag}) to the predicted incidence in the
last period minus \code{irr_lag} (minus \code{t_lag}). For example, if the time period
is in days then setting \code{irr_lag} to 7 and leaving \code{t_lag=0} then the IRR
is the relative change in incidence in the present period compared to a week
prior. These are added to the grid data or to the
regional data for spatially-aggregated data.
}
\examples{
# See examples for grid$lgcp_bayes() and grid$lgcp_ml()
}
