% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qpcrTTEST.r
\name{qpcrTTEST}
\alias{qpcrTTEST}
\title{Fold change (\eqn{\Delta \Delta C_T} method) analysis of target genes using t-test}
\usage{
qpcrTTEST(x, numberOfrefGenes, paired = FALSE, var.equal = TRUE)
}
\arguments{
\item{x}{a data frame of 4 columns including Conditions, E (efficiency), Gene and Ct values (see example below). Biological replicates needs to be equal for all Genes. Each Ct value is the mean of technical replicates. Complete amplification efficiencies of 2 is assumed here for all wells but the calculated efficienies can be used instead.}

\item{numberOfrefGenes}{number of reference genes. Up to two reference genes can be handled.}

\item{paired}{a logical indicating whether you want a paired t-test.}

\item{var.equal}{a logical variable indicating whether to treat the two variances as being equal. If TRUE then the pooled variance is used to estimate the variance otherwise the Welch (or Satterthwaite) approximation to the degrees of freedom is used.}
}
\value{
A list of two elements:
\describe{
  \item{Row_data}{The row data including Genes and weighed delta Ct (wDCt) values.}
  \item{Result}{Output table including the Fold Change values, lower and upper confidence interval and the pvalues from compairing fold change between treated and non-treated conditions}
}
For more information about the test procedure and its arguments,
refer \code{\link[stats]{t.test}}, and \code{\link[stats]{lm}}.
If the residuals of the model do not follow normal distribution and variances between the two groups are not homoGene, \code{\link[stats]{wilcox.test}} procedure may be concidered
}
\description{
t.test based analysis of the fold change expression for any number of target genes.
}
\details{
The \code{qpcrTTEST} function applies a t.test based analysis to calculate fold change (\eqn{\Delta \Delta C_T} method) expression and returns related statistics for any number of target genes along with one or two 
reference gene(s), that have been evaluated under control and treatment conditions. Sampling may be paired or 
unpaired. Paired samples in quantitative PCR refer to two sample data that are collected from one set of individuals 
at two different conditions, for example before and after a treatment or at two different time points. While 
for unpaired samples, two sets of individuals are used: one under untreated and the other set under treated 
condition.  Paired samples allow to compare gene expression changes within the same individual, reducing 
inter-individual variability. Unpaired and paired samples are commonly analyzed using unpaired and paired t-test, respectively.
}
\examples{

# See the sample data structure
data_ttest

# Getting t.test results
qpcrTTEST(data_ttest,
   paired = FALSE,
   var.equal = TRUE,
   numberOfrefGenes = 1)



qpcrTTEST(Taylor_etal2019, 
          numberOfrefGenes = 2, 
          var.equal = TRUE)
 
          
qpcrTTESTplot(Taylor_etal2019, 
              numberOfrefGenes = 2, 
              var.equal = TRUE,
              y.axis.adjust = -0.7,
              y.axis.by = 0.5)


}
\references{
Livak, Kenneth J, and Thomas D Schmittgen. 2001. Analysis of
Relative Gene Expression Data Using Real-Time Quantitative PCR and the
Double Delta CT Method. Methods 25 (4). doi:10.1006/meth.2001.1262.

Ganger, MT, Dietz GD, and Ewing SJ. 2017. A common base method for analysis
of qPCR data and the application of simple blocking in qPCR experiments.
BMC bioinformatics 18, 1-11.

Yuan, Joshua S, Ann Reed, Feng Chen, and Neal Stewart. 2006.
Statistical Analysis of Real-Time PCR Data. BMC Bioinformatics 7 (85).
doi:10.1186/1471-2105-7-85.
}
\author{
Ghader Mirzaghaderi
}
