% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inertCoord.R
\name{indivInertCoordPlots}
\alias{indivInertCoordPlots}
\title{Produces plots of the inertia-coordination model-predicted trajectories overlaid on raw data for each dyad.}
\usage{
indivInertCoordPlots(
  prepData,
  whichModel,
  dist0name = NULL,
  dist1name = NULL,
  plot_obs_name = NULL,
  minMax = NULL,
  printPlots = T
)
}
\arguments{
\item{prepData}{A dataframe that was produced with the "dataPrep" function.}

\item{whichModel}{Whether the model to be estimated is the inertia only model ("inert"), the coordination only model ("coord"), or the full inertia-coordination model ("inertCoord").}

\item{dist0name}{An optional name for the level-0 of the distinguishing variable to appear on plots (e.g., "Women").}

\item{dist1name}{An optional name for the level-1 of the distinguishing variable to appear on plots (e.g., "Men").}

\item{plot_obs_name}{An optional name for the observed state variable to appear on plots (e.g., "Emotional Experience").}

\item{minMax}{An optional vector with desired minimum and maximum quantiles to be used for setting the y-axis range on the plots, e.g., minMax <- c(.1, .9) would set the y-axis limits to the 10th and 90th percentiles of the observed state variables. If not provided, the default is to use the minimum and maximum observed values of the state variables.}

\item{printPlots}{If true (the default) plots are displayed on the screen.}
}
\value{
A list with the plots of the predicted values against the observed values for each dyad.
}
\description{
The observed state variables (with linear trends removed) are predicted from one of the 3 versions of the inertia-coordination model (inertia only, "inert"; coordination only, "coord"; full inertia-coordination, "inertCoord") for each dyad individually. The predicted trajectories are plotted overlaid on the observed trajectories.
}
\examples{
data <- rties_ExampleDataShort
newData <- dataPrep(basedata=data, dyadId="couple", personId="person", 
obs_name="dial", dist_name="female", time_name="time", time_lag=2)
temp <- newData[newData$dyad < 5, ]
plots <- indivInertCoordPlots(prepData=temp, whichModel="inertCoord")

}
