% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plos_article.R
\name{plos_article}
\alias{plos_article}
\title{PLOS journal format.}
\usage{
plos_article(..., keep_tex = TRUE,
  md_extensions = c("-autolink_bare_uris"))
}
\arguments{
\item{...}{Additional arguments to \code{rmarkdown::pdf_document}}

\item{keep_tex}{Keep the intermediate tex file used in the conversion to PDF}

\item{md_extensions}{Markdown extensions to be added or removed from the
default definition or R Markdown. See the \code{\link{rmarkdown_format}} for
additional details.}
}
\value{
R Markdown output format to pass to
  \code{\link[rmarkdown:render]{render}}
}
\description{
Format for creating submissions to PLOS journals. Adapted from
\href{http://journals.plos.org/ploscompbiol/s/latex}{http://journals.plos.org/ploscompbiol/s/latex}.
}
\examples{

\dontrun{
library(rmarkdown)
draft("MyArticle.Rmd", template = "plos_article", package = "rticles")
}

}
