% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colby_constructors.R
\name{analyze_against_ref_group}
\alias{analyze_against_ref_group}
\title{Add ref_group comparison analysis recipe}
\usage{
analyze_against_ref_group(
  lyt,
  var = NA_character_,
  afun,
  label = if (is.na(var)) "" else var,
  compfun = `-`,
  format = NULL,
  nested = TRUE,
  indent_mod = 0L,
  show_labels = c("default", "hidden", "visible")
)
}
\arguments{
\item{lyt}{layout object pre-data used for tabulation}

\item{var}{string, variable name}

\item{afun}{function. Analysis function, must take \code{x} or \code{df} as its first parameter. Can optionally take other parameters which will be populated by the tabulation framework. See Details in \code{\link{analyze}}.}

\item{label}{character(1). A label (not to be confused with the name) for the object/structure.}

\item{compfun}{function/string. The comparison function which accepts the analysis function outputs for two different partitions and returns a single value. Defaults to subraction. If a string, taken as the name of a function.}

\item{format}{FormatSpec. Format associated with this split. Formats can be declared via strings (\code{"xx.x"}) or function. In cases such as \code{analyze} calls, they can character vectors or lists of functions.}

\item{nested}{boolean, Add this as a new top-level split  (defining a new subtable directly under root). Defaults to \code{FALSE}}

\item{indent_mod}{numeric. Modifier for the default indent position for the structure created by this function(subtable, content table, or row) \emph{and all of that structure's children}. Defaults to 0, which corresponds to the unmodified default behavior.}

\item{show_labels}{character(1). Should the variable labels for corresponding to the variable(s) in \code{vars} be visible in the resulting table.}
}
\value{
A \code{PreDataTableLayouts} object suitable for passing to further layouting functions, and to \code{build_table}.
}
\description{
Add ref_group comparison analysis recipe
}
\details{
Please see the \code{baseline} vignette for more details.
}
\examples{

basic_table() \%>\%
    split_cols_by("ARM", ref_group = "B: Placebo") \%>\%
    analyze("AGE", afun = function(x, .ref_group) {
        in_rows(
            "Difference of Averages" = rcell(mean(x) - mean(.ref_group), format = "xx.xx")
        )
    }) \%>\%
    build_table(DM)
}
\author{
Gabriel Becker
}
