% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/as.FlexTable.xtable.R
\name{as.FlexTable.xtable}
\alias{as.FlexTable.xtable}
\title{get FlexTable from a xtable object}
\usage{
\method{as.FlexTable}{xtable}(x, text.properties = textNormal(),
  format.args = list(), hline.after = getOption("xtable.hline.after", c(-1,
  0, nrow(x))), padding.left = 4, padding.right = 4, ...)
}
\arguments{
\item{x}{\code{xtable} object to get \code{FlexTable} from}

\item{text.properties}{default text formatting properties}

\item{format.args}{List of arguments for the formatC function.
See argument \code{format.args} of \code{print.xtable}}

\item{hline.after}{a vector of numbers between -1 and "nrow(x)",
inclusive, indicating the rows after which a horizontal line should appear.
see argument \code{hline.after} of \code{print.xtable}.}

\item{padding.left}{cells paragraphs left padding - 0 or positive integer value.}

\item{padding.right}{cells paragraphs right padding - 0 or positive integer value.}

\item{...}{further arguments, not used.}
}
\value{
a \code{\link{FlexTable}} object
}
\description{
Get a \code{\link{FlexTable}} object from
a \code{\link{xtable}} object.
}
\examples{
#
data(tli)

tli.table <- xtable(tli[1:10,])
digits(tli.table)[c(2,6)] <- 0
FT = as.FlexTable( x = tli.table )
print( FT )
if( interactive() ) readline("Hit <Return> to see next FlexTable:")


align(tli.table) <- "|rrl|l|lr|"
FT = as.FlexTable( x = tli.table )
print( FT )
if( interactive() ) readline("Hit <Return> to see next FlexTable:")


fm1 <- aov(tlimth ~ sex + ethnicty + grade + disadvg, data=tli)
fm1.table <- xtable(fm1)
FT = as.FlexTable( x = fm1.table )
print( FT )
if( interactive() ) readline("Hit <Return> to see next FlexTable:")


bktbs <- xtable(matrix(1:10, ncol = 2))
hlines <- c(-1,0,1,nrow(bktbs))
FT = as.FlexTable(bktbs, hline.after = hlines )
print( FT )

}

