% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/folderId.R
\name{folderId}
\alias{folderId}
\alias{folderId,character-method}
\alias{folderId,Folder-method}
\alias{folderId,Scenario-method}
\alias{folderId<-}
\alias{folderId<-,Scenario-method}
\title{Retrieves folderId of SyncroSim Folder or Scenario}
\usage{
folderId(ssimObject)

\S4method{folderId}{character}(ssimObject)

\S4method{folderId}{Folder}(ssimObject)

\S4method{folderId}{Scenario}(ssimObject)

folderId(ssimObject) <- value

\S4method{folderId}{Scenario}(ssimObject) <- value
}
\arguments{
\item{ssimObject}{\code{\link{Folder}} or \code{\link{Scenario}} object}

\item{value}{integer of the folder ID to move the \code{\link{Scenario}} to.
Only applicable if the ssimObject provided is a \code{\link{Scenario}}.}
}
\value{
An integer: folder id.
}
\description{
Retrieves the Folder Id of a SyncroSim \code{\link{Folder}} or
\code{\link{Scenario}}. Can also use to set the Folder Id for a
\code{\link{Scenario}} - this will move the \code{\link{Scenario}} into the
desired folder in the SyncroSim User Interface.
}
\examples{
\dontrun{
# Set the file path and name of the new SsimLibrary
myLibraryName <- file.path(tempdir(),"testlib")

# Set the SyncroSim Session, SsimLibrary, Project, and Scenario
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName, 
                         session = mySession, 
                         overwrite = TRUE) 
myProject <- project(myLibrary, project = "Definitions")
myScenario <- scenario(myProject, scenario = "My Scenario")
myFolder <- folder(myProject, "New Folder")

# Get Folder ID for SyncroSim Folder and Scenario
folderId(myFolder)
folderId(myScenario)

# Move the Scenario into the newly created folder
folderId(myScenario) <- folderId(myFolder)
folderId(myScenario)
}

}
