% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependency.R
\name{dependency}
\alias{dependency}
\alias{dependency,character-method}
\alias{dependency,Scenario-method}
\alias{dependency<-}
\alias{dependency<-,Scenario-method}
\title{Get, set or remove Scenario dependencies}
\usage{
dependency(ssimObject)

\S4method{dependency}{character}(ssimObject)

\S4method{dependency}{Scenario}(ssimObject)

dependency(ssimObject) <- value

\S4method{dependency}{Scenario}(ssimObject) <- value
}
\arguments{
\item{ssimObject}{\code{\link{Scenario}} object, character string, integer, or
vector of these. The Scenario object, name, or ID to which a dependency is to
be added (or has already been added if \code{remove=TRUE}). Note that integer ids
are slightly faster.}

\item{value}{\code{\link{Scenario}} object, character string, integer, or
vector of these. The Scenario object, name, or ID to be used as the
dependency. If an empty vector is provided, all dependencies are removed. If
multiple elements are provided, elements should be ordered from highest to lowest
precedence.}
}
\value{
A data.frame: all dependencies for a given Scenario
}
\description{
List dependencies, set dependencies, or remove dependencies from a SyncroSim
\code{\link{Scenario}}. Setting dependencies is a way of linking together
Scenario Datafeeds, such that a change in the Scenario that is the source
dependency will update the dependent Scenario as well.
}
\details{
If \code{dependency==NULL}, other arguments are ignored, and set of existing dependencies
is returned in order of precedence (from highest to lowest precedence).
Otherwise, returns list of saved or error messages for each dependency of each
scenario.

Note that pre-existing dependencies will be removed when adding new dependencies unless
those elements are included in the vector of new dependencies.
}
\examples{
\dontrun{
# Specify file path and name of new SsimLibrary
myLibraryName <- file.path(tempdir(), "testlib")

# Set up a SyncroSim Session, SsimLibrary, Project, and 2 Scenarios
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName, session = mySession)
myProject <- project(myLibrary, project = "Definitions")
myScenario <- scenario(myProject, scenario = "My Scenario")
myNewScenario <- scenario(myProject,
                          scenario = "my New Scenario")

# Set myScenario as a dependency of myNewScenario
dependency(myNewScenario) <- myScenario

# Get all dependencies info
dependency(myNewScenario)

# Remove all dependencies
dependency(myNewScenario) <- c()
}

}
