% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chartDisagg.R
\name{chartDisagg}
\alias{chartDisagg}
\alias{chartDisagg,Chart-method}
\title{Disaggregates the \code{\link{Chart}} by a Y variable}
\usage{
chartDisagg(chart, variable, addFilter = NULL, removeFilter = NULL)

\S4method{chartDisagg}{Chart}(chart, variable, addFilter = NULL, removeFilter = NULL)
}
\arguments{
\item{chart}{\code{\link{Chart}} object}

\item{variable}{character. The variable to disaggregate the Y axis by.}

\item{addFilter}{character or character vector. Adds Y variable column(s) to
disaggregate the chart by.}

\item{removeFilter}{character or character vector. Removes Y variable
column(s) from disaggregating the chart.}
}
\value{
A \code{Chart} object representing a SyncroSim chart
}
\description{
Disaggregates the \code{\link{Chart}} by given filter column(s) in a Y
variable.
}
\examples{
\dontrun{
# Create a chart object
myChart <- chart(myProject, chart = "New Chart")

# Set the chart type and data
myChart <- chartData(myChart, y = c("variable1", "variable2"),
timesteps = c(0,10), iterationType = "single", iteration = 1)

# Disaggregate the chart by a filter column
myChart <- chartDisagg(myChart, variable = "variable1",
addFilter=c("col1", "col2"))

# Remove a filter column from the chart disaggregation
myChart <- chartDisagg(myChart, variable = "variable1",
removeFilter="col1")
}

}
