% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssimUpdate.R
\name{ssimUpdate}
\alias{ssimUpdate}
\alias{ssimUpdate,character-method}
\alias{ssimUpdate,SsimObject-method}
\title{Apply updates}
\usage{
ssimUpdate(ssimObject)

\S4method{ssimUpdate}{character}(ssimObject)

\S4method{ssimUpdate}{SsimObject}(ssimObject)
}
\arguments{
\item{ssimObject}{\code{\link{Session}}, \code{\link{Project}}, 
or \code{\link{SsimLibrary}} object. If \code{NULL} (default), 
\code{session()} will be used}
}
\value{
Invisibly returns \code{TRUE} upon success (i.e.successful 
update) and \code{FALSE} upon failure.
}
\description{
Apply updates to a \code{\link{SsimLibrary}}, or a \code{\link{Project}} or 
\code{\link{Scenario}} associated with a SsimLibrary.
}
\examples{
\donttest{
# Set the file path and name of the new SsimLibrary
myLibraryName <- file.path(tempdir(),"testlib")

# Set the SyncroSim Session, SsimLibrary, and Project
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName, session = mySession,
                         overwrite=TRUE)
myProject <- project(myLibrary, project = "My Project")

# Update Project
ssimUpdate(myProject)

# Create Scenario
myScenario <- scenario(myLibrary, scenario = "My Scenario")

# Update scenario
ssimUpdate(myScenario)
}

}
