% Generated by roxygen2 (4.0.1): do not edit by hand
\name{cg_upcoming_bills}
\alias{cg_upcoming_bills}
\title{Search for data on upcoming bills.}
\usage{
cg_upcoming_bills(scheduled_at = NULL, legislative_day = NULL,
  range = NULL, congress = NULL, chamber = NULL, source_type = NULL,
  bill_id = NULL, query = NULL, fields = NULL, page = 1,
  per_page = 20, order = NULL, key = getOption("SunlightLabsKey",
  stop("need an API key for Sunlight Labs")), return = "table", ...)
}
\arguments{
\item{scheduled_at}{The exact time at which our systems first spotted this bill on the schedule
in this chamber and on this legislative day. Currently, we check the schedules every 15 minutes.}

\item{legislative_day}{The legislative day this bill is scheduled for. Combine with the range
field to understand precision. May be null.}

\item{range}{How precise this information is. One of 'day', 'week', or NULL. See Details for
more.}

\item{congress}{The number of the Congress this bill has been scheduled in.}

\item{chamber}{The chamber which has scheduled this bill.}

\item{source_type}{The source for this information. 'house_daily' (Majority Leader daily
schedule or 'senate_daily' (Senate Democrats' Floor feed.}

\item{bill_id}{The ID of the bill that is being scheduled.}

\item{fields}{You can request specific fields by supplying a vector of fields names. Many fields
are not returned unless requested. If you don't supply a fields parameter, you will get the
most commonly used subset of fields only. To save on bandwidth, parsing time, and confusion,
it's recommended to always specify which fields you will be using.}

\item{key}{your SunlightLabs API key; loads from .Rprofile}

\item{return}{(character) One of table (default), list, or response (httr response object).
When table is requested, the default, a table is not always returned, but is returned almost
always. You can then make a table yourself if you like.}

\item{...}{Optional additional curl options (debugging tools mostly). See examples.}

\item{page}{Page to return. Default: 1. You can use this in combination with the
per_page parameter to get more than the default or max number of results per page.}

\item{per_page}{Number of records to return. Default: 20. Max: 50.}

\item{order}{Sort results by one or more fields with the order parameter. order is
optional, but if no order is provided, the order of results is not guaranteed to be predictable.
Append \code{__asc} or \code{__desc} to the field names to control sort direction. The default
direction is \code{desc}, because it is expected most queries will sort by a date. Any field
which can be used for filtering may be used for sorting. On full-text search endpoints (URLs
ending in \code{/search}), you may sort by score to order by relevancy.}

\item{query}{(character) Return results the API thinks best match your query. Queries are
interpreted as phrases.}
}
\description{
Search for data on upcoming bills.
}
\details{
More info for range parameter
\itemize{
 \item day: bill has been scheduled specifically for the legislative_day.
 \item week: bill has been scheduled for the 'Week of' the legislative_day.
 \item NULL: bill has been scheduled at an indefinite time in the future. (legislative_day
 is null.)
}

The 'legislative day' is a formal construct that is usually, but not always, the same as the
calendar day. For example, if a day's session of Congress runs past midnight, the
legislative_day will often stay the same as it was before midnight, until that session adjourns.
On January 3rd, it is possible that the same legislative_day could span two Congresses.
(This occurred in 2013.)
}
\examples{
\dontrun{
cg_upcoming_bills()
}
}

