% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorial_design.R
\name{factorial_design}
\alias{factorial_design}
\title{Build Factorial Designs for ANOVA}
\usage{
factorial_design(data, dv, wid, between, within, covariate)
}
\arguments{
\item{data}{a data frame containing the variables}

\item{dv}{(numeric) dependent variable name.}

\item{wid}{(factor) column name containing individuals/subjects identifier.
Should be unique per individual.}

\item{between}{(optional) between-subject factor variables.}

\item{within}{(optional) within-subjects factor variables}

\item{covariate}{(optional) covariate names (for ANCOVA)}

\item{...}{within variable names (i.e., repeated measure variables)}
}
\value{
a list with the following components: \itemize{ \item \strong{the
 specified arguments}: \code{dv, wid, between, within} \item \strong{data}:
 the original data (long format) or independent ANOVA. The wide format is
 returned for repeated measures ANOVA. \item \strong{idata}: an optional data
 frame giving the levels of factors defining the intra-subject model for
 multivariate repeated-measures data. \item \strong{idesign}: a one-sided
 model formula using the “data” in idata and specifying the intra-subject
 design. \item \strong{repeated}: logical. Value is TRUE when the data is a
 repeated design. \item \strong{lm_formula}: the formula used to build the
 \code{lm} model. \item \strong{lm_data}: the data used to build the \code{lm}
 model. Can be either in a long format (i.e., the original data for
 independent measures ANOVA) or in a wide format (case of repeated measures ANOVA). \item \strong{model}: the \code{lm} model }
}
\description{
Provides helper functions to build factorial design for easily
 computing ANOVA using the \code{\link[car]{Anova}()} function. This might be
 very useful for repeated measures ANOVA, which is hard to set up with the
 \code{car} package.
}
\examples{
# Load data
#:::::::::::::::::::::::::::::::::::::::
data("ToothGrowth")
df <- ToothGrowth
head(df)

# Repeated measures designs
#:::::::::::::::::::::::::::::::::::::::::
# Prepare the data
df$id <- rep(1:10, 6) # Add individuals id
head(df)
# Build factorial designs
design <- factorial_design(df, dv = len, wid = id, within = c(supp, dose))
design
# Easily perform repeated measures ANOVA using the car package
res.anova <- Anova(design$model, idata = design$idata, idesign = design$idesign, type = 3)
summary(res.anova, multivariate = FALSE)

# Independent measures designs
#:::::::::::::::::::::::::::::::::::::::::
# Build factorial designs
df$id <- 1:nrow(df)
design <- factorial_design(df, dv = len, wid = id, between = c(supp, dose))
design
# Perform ANOVA
Anova(design$model, type = 3)

}
\seealso{
\code{\link{anova_test}()}, \code{\link{anova_summary}()}
}
\author{
Alboukadel Kassambara, \email{alboukadel.kassambara@gmail.com}
}
